<?php
require_once __DIR__.'/config.php';
require_once __DIR__.'/db.php';
require_once __DIR__.'/tg.php';
require_once __DIR__.'/i18n.php';
require_once __DIR__.'/helpers.php';

if (isset($_GET['secret']) && $_GET['secret'] !== WEBHOOK_SECRET) { http_response_code(403); exit('Forbidden'); }

$raw = file_get_contents('php://input');
$up = json_decode($raw, true);
dbg($up);
if(!$up){ exit('OK'); }

function get_or_create_user($from){
    $row = q("SELECT * FROM users WHERE telegram_id=?",[$from['id']])->fetch();
    if(!$row){
        q("INSERT INTO users(telegram_id,username,first_name,last_name,language,language_selected,created_at) VALUES(?,?,?,?,?,?,NOW())",[
            $from['id'], $from['username']??null, $from['first_name']??'', $from['last_name']??'', DEFAULT_LANG, 0
        ]);
        $row = q("SELECT * FROM users WHERE telegram_id=?",[$from['id']])->fetch();
    } else {
        q("UPDATE users SET username=?, first_name=?, last_name=? WHERE id=?",[$from['username']??null,$from['first_name']??'',$from['last_name']??'',$row['id']]);
    }
    return $row;
}
function set_lang($tgid,$lang){ q("UPDATE users SET language=?, language_selected=1 WHERE telegram_id=?",[$lang,$tgid]); }
function get_lang($user){ return $user['language'] ?: DEFAULT_LANG; }
function list_departments(){ return q("SELECT * FROM departments WHERE is_active=1 ORDER BY sort_order,id")->fetchAll(); }
function dept($id){ return q("SELECT * FROM departments WHERE id=?",[$id])->fetch(); }
function list_user_tickets($tgid){
    $rows = q("SELECT * FROM tickets WHERE user_telegram_id=? ORDER BY updated_at DESC LIMIT 20",[$tgid])->fetchAll();
    if(!$rows) return null;
    $btn=[]; $lines=[];
    foreach($rows as $r){ $lines[]="• {$r['uid']} — {$r['status']} — ".date('Y-m-d H:i',strtotime($r['updated_at'])); $btn[]=[['text'=>$r['uid'],'callback_data'=>'open_ticket:'.$r['id']]]; }
    return [implode("\n",$lines), ['inline_keyboard'=>$btn]];
}
function create_ticket($user,$dept_id,$payload){
    $uid = ticket_uid();
    q("INSERT INTO tickets(uid,user_id,user_telegram_id,department_id,status,priority,created_at,updated_at,last_message_by) VALUES(?,?,?,?, 'open','normal', NOW(), NOW(),'user')",
      [$uid,$user['id'],$user['telegram_id'],$dept_id]);
    $t = q("SELECT * FROM tickets WHERE uid=?",[$uid])->fetch();
    q("INSERT INTO messages(ticket_id,sender_type,sender_telegram_id,text,file_type,file_id,is_agent_reply,is_read_by_user,created_at) VALUES(?,?,?,?,?,?,0,0,NOW())",
      [$t['id'],'user',$user['telegram_id'],$payload['text'],$payload['file_type'],$payload['file_id']]);
    return q("SELECT t.*, d.name_en, d.name_fa FROM tickets t JOIN departments d ON d.id=t.department_id WHERE t.id=?",[$t['id']])->fetch();
}
function notify_new_ticket($ticket_row){
    $dept = dept($ticket_row['department_id']);
    $text = "🆕 <b>New Ticket</b> {$ticket_row['uid']}\nDept: ".($dept['name_en'])."\nTime: ".date('Y-m-d H:i');
    $kb = inl_admin_ticket($ticket_row['id']);
    if(!empty($dept['support_chat_id'])) tg_sendMessage($dept['support_chat_id'],$text,$kb);
    foreach(ADMIN_MANAGER_IDS as $mid){ tg_sendMessage($mid,$text,$kb); }
}
function save_message($ticket_id,$sender_type,$sender_tid,$payload){
    q("INSERT INTO messages(ticket_id,sender_type,sender_telegram_id,text,file_type,file_id,is_agent_reply,is_read_by_user,created_at) VALUES(?,?,?,?,?,?,?,0,NOW())",
      [$ticket_id,$sender_type,$sender_tid,$payload['text'],$payload['file_type'],$payload['file_id'],$sender_type==='agent'?1:0]);
    q("UPDATE tickets SET updated_at=NOW(), last_message_by=? WHERE id=?",[$sender_type,$ticket_id]);
    return (int)db()->lastInsertId();
}
function sess_set($tgid,$mode,$data=[],$ttl_min=30){ q("REPLACE INTO sessions(telegram_id,mode,data_json,expires_at) VALUES(?,?,?,DATE_ADD(NOW(), INTERVAL ? MINUTE))",[$tgid,$mode,json_encode($data,JSON_UNESCAPED_UNICODE),$ttl_min]); }
function sess_get($tgid){ $r=q("SELECT * FROM sessions WHERE telegram_id=? AND expires_at>NOW()",[$tgid])->fetch(); if(!$r) return null; $r['data']=$r['data_json']?json_decode($r['data_json'],true):[]; return $r; }
function sess_clear($tgid){ q("DELETE FROM sessions WHERE telegram_id=?",[$tgid]); }

if(isset($up['message'])){
    $m=$up['message']; $from=$m['from']; $chat_id=$m['chat']['id']; $user=get_or_create_user($from);
    $lang = get_lang($user);
    $isAgent = is_agent($from['id']);
    $menu = $isAgent ? admin_main_menu($lang) : user_main_menu($lang);

    if(isset($m['text'])){
        $text = trim($m['text']);
        if($text === '/start'){
            $wel = t('welcome',$lang);
            if($isAgent) $wel .= "\n\n".t('admin_mode',$lang);
            tg_sendMessage($chat_id,$wel,$menu);
            if ((int)$user['language_selected'] === 0){
                tg_sendMessage($chat_id, t('lang_choose',$lang), ['inline_keyboard'=>[[['text'=>'English 🇬🇧','callback_data'=>'lang:en'],['text'=>'فارسی 🇮🇷','callback_data'=>'lang:fa']]]]);
            }
            exit;
        }
        if(!$isAgent && ($text===t('btn_new',$lang))){
            $deps = list_departments();
            tg_sendMessage($chat_id, t('select_dept',$lang), inl_depts($deps,$lang));
            sess_set($from['id'],'selecting_department',[]);
            exit;
        }
        if(!$isAgent && ($text===t('btn_mine',$lang))){
            $l = list_user_tickets($from['id']);
            if(!$l) tg_sendMessage($chat_id,t('no_tickets',$lang),$menu);
            else tg_sendMessage($chat_id, t('my_tickets',$lang)."\n\n".$l[0], $l[1]);
            exit;
        }
        if($text===t('btn_lang',$lang)){
            tg_sendMessage($chat_id, t('lang_choose',$lang), ['inline_keyboard'=>[[['text'=>'English 🇬🇧','callback_data'=>'lang:en'],['text'=>'فارسی 🇮🇷','callback_data'=>'lang:fa']]]]);
            exit;
        }
        if($isAgent && $text===t('inbox',$lang)){
            $where = is_manager($from['id']) ? "" : "WHERE department_id IN (".implode(',',array_map('intval',agent_departments($from['id']))).")";
            $rows = q("SELECT t.*, d.name_en FROM tickets t JOIN departments d ON d.id=t.department_id $where ORDER BY t.updated_at DESC LIMIT 20")->fetchAll();
            if(!$rows){ tg_sendMessage($chat_id,"Inbox empty."); exit; }
            $kbd=['inline_keyboard'=>[]]; foreach($rows as $r){ $kbd['inline_keyboard'][]=[[ 'text'=>$r['uid'].' — '.$r['name_en'].' — '.$r['status'],'callback_data'=>'admin_view:'.$r['id'] ]]; }
            tg_sendMessage($chat_id,"📥 Inbox (latest 20):",$kbd); exit;
        }
        if($isAgent && $text===t('dept_tickets',$lang)){
            $deps = agent_departments($from['id']); if(!$deps){ tg_sendMessage($chat_id,"No department linked."); exit; }
            $ph = implode(',',array_fill(0,count($deps),'?'));
            $rows = q("SELECT t.*, d.name_en FROM tickets t JOIN departments d ON d.id=t.department_id WHERE t.department_id IN ($ph) ORDER BY t.updated_at DESC LIMIT 20",$deps)->fetchAll();
            if(!$rows){ tg_sendMessage($chat_id,"No tickets."); exit; }
            $kbd=['inline_keyboard'=>[]]; foreach($rows as $r){ $kbd['inline_keyboard'][]=[[ 'text'=>$r['uid'].' — '.$r['name_en'].' — '.$r['status'],'callback_data'=>'admin_view:'.$r['id'] ]]; }
            tg_sendMessage($chat_id,"🎯 My Dept Tickets:",$kbd); exit;
        }
        if($isAgent && $text===t('find_ticket',$lang)){
            sess_set($from['id'],'find_ticket',[]);
            tg_sendMessage($chat_id,"Send ticket UID (e.g. TCK-20250101-ABCD)");
            exit;
        }
    }

    $sess = sess_get($from['id']);
    if($sess){
        if($sess['mode']==='creating_ticket' && !$isAgent){
            $payload = payload_from_message($m);
            if(!$payload['text'] && !$payload['file_id']){ tg_sendMessage($chat_id, t('send_msg',$lang)); exit; }
            $t = create_ticket($user, $sess['data']['department_id'], $payload);
            $dept_name = $lang==='fa' ? ($t['name_fa']?:$t['name_en']) : $t['name_en'];
            tg_sendMessage($chat_id, t('ticket_created',$lang,['uid'=>$t['uid'],'dept'=>$dept_name]), user_main_menu($lang));
            notify_new_ticket($t);
            sess_clear($from['id']);
            exit;
        }
        if($sess['mode']==='user_replying' && !$isAgent){
            $payload = payload_from_message($m);
            if(!$payload['text'] && !$payload['file_id']){ tg_sendMessage($chat_id, t('send_msg',$lang)); exit; }
            $tid = (int)$sess['data']['ticket_id'];
            save_message($tid,'user',$from['id'],$payload);
            q("UPDATE tickets SET status='waiting_agent' WHERE id=?",[$tid]);
            tg_sendMessage($chat_id, t('reply_sent',$lang), user_main_menu($lang));
            sess_clear($from['id']);
            exit;
        }
        if($sess['mode']==='admin_replying' && $isAgent){
            $payload = payload_from_message($m);
            if(!$payload['text'] && !$payload['file_id']){ tg_sendMessage($chat_id, "Send a message..."); exit; }
            $tid = (int)$sess['data']['ticket_id'];
            $mid = save_message($tid,'agent',$from['id'],$payload);
            $t = q("SELECT * FROM tickets WHERE id=?",[$tid])->fetch();
            $kb = ['inline_keyboard'=>[[['text'=>t('view_reply',get_lang($user)),'callback_data'=>'view_reply:'.$tid.':'.$mid]]]];
            tg_sendMessage($t['user_telegram_id'], t('support_replied','en',['uid'=>$t['uid']]), $kb);
            q("UPDATE tickets SET status='answered' WHERE id=?",[$tid]);
            tg_sendMessage($chat_id, t('reply_sent',$lang), admin_main_menu($lang));
            sess_clear($from['id']);
            exit;
        }
        if($sess['mode']==='find_ticket' && $isAgent && isset($m['text'])){
            $uid = strtoupper(trim($m['text']));
            $t = q("SELECT * FROM tickets WHERE uid=?",[$uid])->fetch();
            if(!$t){ tg_sendMessage($chat_id,"Not found."); exit; }
            tg_sendMessage($chat_id, "Found: {$t['uid']}", inl_admin_ticket($t['id']));
            sess_clear($from['id']);
            exit;
        }
    }
    exit('OK');
}

if(isset($up['callback_query'])){
    $cb=$up['callback_query']; $from=$cb['from']; $msg=$cb['message']??null; $chat_id=$msg?$msg['chat']['id']:$from['id'];
    $user = get_or_create_user($from); $lang=get_lang($user);
    $isAgent = is_agent($from['id']);

    $data = $cb['data'];
    if(str_starts_with($data,'lang:')){
        $langc = explode(':',$data)[1] ?? 'en';
        set_lang($from['id'],$langc);
        tg_answerCb($cb['id'],'OK');
        tg_sendMessage($chat_id, $langc==='fa'?t('lang_set_fa','fa'):t('lang_set_en','en'), $isAgent?admin_main_menu($langc):user_main_menu($langc));
        exit;
    }
    if($data==='back_main'){
        tg_answerCb($cb['id'],'OK');
        tg_sendMessage($chat_id,'⬅️',$isAgent?admin_main_menu($lang):user_main_menu($lang));
        exit;
    }
    if(str_starts_with($data,'select_dept:')){
        $dept_id = (int)explode(':',$data)[1];
        sess_set($from['id'],'creating_ticket',['department_id'=>$dept_id],30);
        tg_answerCb($cb['id'],'OK');
        tg_sendMessage($chat_id, t('send_msg',$lang));
        exit;
    }
    if(str_starts_with($data,'open_ticket:')){
        $tid = (int)explode(':',$data)[1];
        $t = q("SELECT t.*, d.name_en,d.name_fa FROM tickets t JOIN departments d ON d.id=t.department_id WHERE t.id=?",[$tid])->fetch();
        $name = $lang==='fa'?($t['name_fa']?:$t['name_en']):$t['name_en'];
        $txt = "🎫 <b>{$t['uid']}</b>\nDept: {$name}\nStatus: {$t['status']}";
        tg_answerCb($cb['id'],'OK');
        tg_sendMessage($chat_id,$txt, inl_user_ticket($tid,$lang));
        exit;
    }
    if(str_starts_with($data,'user_reply:')){
        $tid = (int)explode(':',$data)[1];
        sess_set($from['id'],'user_replying',['ticket_id'=>$tid],30);
        $t=q("SELECT * FROM tickets WHERE id=?",[$tid])->fetch();
        tg_answerCb($cb['id'],'OK');
        tg_sendMessage($chat_id, t('user_reply_prompt',$lang,['uid'=>$t['uid']]));
        exit;
    }
    if(str_starts_with($data,'user_close:')){
        $tid = (int)explode(':',$data)[1];
        $t=q("SELECT * FROM tickets WHERE id=?",[$tid])->fetch();
        q("UPDATE tickets SET status='closed' WHERE id=?",[$tid]);
        tg_answerCb($cb['id'],'OK');
        tg_sendMessage($chat_id, t('ticket_closed',$lang,['uid'=>$t['uid']]));
        exit;
    }
    if(str_starts_with($data,'admin_view:')){
        $tid = (int)explode(':',$data)[1];
        $t = q("SELECT t.*, u.username, d.name_en FROM tickets t JOIN users u ON u.id=t.user_id JOIN departments d ON d.id=t.department_id WHERE t.id=?",[$tid])->fetch();
        $txt = "🎫 <b>{$t['uid']}</b>\nDept: {$t['name_en']}\nFrom: @{$t['username']}\nStatus: {$t['status']}\nUpdated: ".date('Y-m-d H:i',strtotime($t['updated_at']));
        tg_answerCb($cb['id'],'OK');
        tg_sendMessage($chat_id,$txt, inl_admin_ticket($tid));
        exit;
    }
    if(str_starts_with($data,'admin_reply:')){
        $tid = (int)explode(':',$data)[1];
        $t=q("SELECT * FROM tickets WHERE id=?",[$tid])->fetch();
        sess_set($from['id'],'admin_replying',['ticket_id'=>$tid],60);
        tg_answerCb($cb['id'],'Check DM');
        tg_sendMessage($from['id'], t('admin_reply_prompt','en',['uid'=>$t['uid']]), admin_main_menu('en'));
        exit;
    }
    if(str_starts_with($data,'admin_assign:')){
        $tid = (int)explode(':',$data)[1];
        q("UPDATE tickets SET assigned_admin_id=? WHERE id=?",[$from['id'],$tid]);
        tg_answerCb($cb['id'],'Assigned');
        exit;
    }
    if(str_starts_with($data,'admin_close:')){
        $tid = (int)explode(':',$data)[1];
        $t=q("SELECT * FROM tickets WHERE id=?",[$tid])->fetch();
        q("UPDATE tickets SET status='closed' WHERE id=?",[$tid]);
        tg_answerCb($cb['id'],'Closed');
        tg_sendMessage($chat_id, "Closed {$t['uid']}");
        tg_sendMessage($t['user_telegram_id'], t('ticket_closed','en',['uid'=>$t['uid']]));
        exit;
    }
    if(str_starts_with($data,'view_reply:')){
        $parts = explode(':',$data);
        $tid=(int)$parts[1]; $mid=(int)$parts[2];
        $msg = q("SELECT * FROM messages WHERE id=? AND ticket_id=?",[$mid,$tid])->fetch();
        if($msg){
            send_payload($from['id'], ['text'=>$msg['text'],'file_type'=>$msg['file_type'],'file_id'=>$msg['file_id']], '');
            q("UPDATE messages SET is_read_by_user=1 WHERE id=?",[$mid]);
            $t=q("SELECT * FROM tickets WHERE id=?",[$tid])->fetch();
            if($msg['sender_type']==='agent'){ tg_sendMessage($msg['sender_telegram_id'], "✅ User viewed your reply on {$t['uid']}"); }
            foreach(ADMIN_MANAGER_IDS as $midm){ tg_sendMessage($midm, "👀 User viewed reply on {$t['uid']}"); }
        }
        tg_answerCb($cb['id'],'Opened');
        exit;
    }
    exit('OK');
}
