<?php
$I18N = [
'en' => [
 'welcome' => "👋 Welcome! I'm your support bot.\nUse buttons below.",
 'lang_choose' => "🌐 Choose your language:",
 'lang_set_en' => "Language set to English. 🇬🇧",
 'lang_set_fa' => "زبان به فارسی تنظیم شد. 🇮🇷",
 'btn_new' => "🆕 New Ticket",
 'btn_mine' => "🎫 My Tickets",
 'btn_lang' => "🌐 Language",
 'select_dept' => "📂 Choose a department:",
 'send_msg' => "✏️ Send your message (you can also send photo/video).",
 'ticket_created' => "✅ Ticket {uid} created in {dept}.",
 'no_tickets' => "You have no tickets yet.",
 'my_tickets' => "🎫 Your tickets:",
 'user_reply_prompt' => "✍️ Send your reply for {uid}.",
 'admin_reply_prompt' => "✍️ Send your reply to user for {uid}.",
 'support_replied' => "📣 Support replied to ticket {uid}.",
 'ticket_closed' => "🔒 Ticket {uid} closed.",
 'view_reply' => "📬 View reply",
 'reply_sent' => "✅ Reply sent.",
 'status_open' => "Open",
 'status_answered' => "Answered",
 'status_waiting_user' => "Awaiting User",
 'status_closed' => "Closed",
 'admin_mode' => "🛡 Admin mode enabled.",
 'inbox' => "📥 Inbox",
 'dept_tickets' => "🎯 My Dept Tickets",
 'find_ticket' => "🔎 Find Ticket",
],
'fa' => [
 'welcome' => "👋 سلام! من بات پشتیبانی شما هستم.\nاز دکمه‌های زیر استفاده کنید.",
 'lang_choose' => "🌐 زبان خود را انتخاب کنید:",
 'lang_set_en' => "Language set to English. 🇬🇧",
 'lang_set_fa' => "زبان به فارسی تنظیم شد. 🇮🇷",
 'btn_new' => "🆕 تیکت جدید",
 'btn_mine' => "🎫 تیکت‌های من",
 'btn_lang' => "🌐 زبان",
 'select_dept' => "📂 دپارتمان مورد نظر را انتخاب کنید:",
 'send_msg' => "✏️ پیام خود را ارسال کنید (امکان ارسال عکس/ویدیو وجود دارد).",
 'ticket_created' => "✅ تیکت {uid} در {dept} ثبت شد.",
 'no_tickets' => "هنوز هیچ تیکتی ندارید.",
 'my_tickets' => "🎫 تیکت‌های شما:",
 'user_reply_prompt' => "✍️ پاسخ خود را برای {uid} ارسال کنید.",
 'admin_reply_prompt' => "✍️ پاسخ خود به کاربر برای {uid} را ارسال کنید.",
 'support_replied' => "📣 پشتیبانی به تیکت {uid} پاسخ داد.",
 'ticket_closed' => "🔒 تیکت {uid} بسته شد.",
 'view_reply' => "📬 مشاهده پاسخ",
 'reply_sent' => "✅ پاسخ ارسال شد.",
 'status_open' => "باز",
 'status_answered' => "پاسخ داده شد",
 'status_waiting_user' => "منتظر کاربر",
 'status_closed' => "بسته",
 'admin_mode' => "🛡 حالت ادمین فعال شد.",
 'inbox' => "📥 صندوق",
 'dept_tickets' => "🎯 تیکت‌های دپارتمان من",
 'find_ticket' => "🔎 جستجوی تیکت",
]
];
function t($k,$lang='en',$vars=[]){
    global $I18N;
    $txt = $I18N[$lang][$k] ?? $k;
    foreach($vars as $kk=>$vv) $txt = str_replace('{'.$kk.'}', $vv, $txt);
    return $txt;
}
