<?php
function tg($method, $params=[]) {
    $ch = curl_init(API_URL.$method);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    $res = curl_exec($ch);
    if ($res === false) { dbg('curl: '.curl_error($ch)); curl_close($ch); return ['ok'=>false]; }
    curl_close($ch);
    $data = json_decode($res, true);
    if (!$data) dbg('tg bad json: '.$res);
    return $data ?: ['ok'=>false];
}
function tg_sendMessage($chat_id,$text,$reply_markup=null,$parse='HTML'){
    $p=['chat_id'=>$chat_id,'text'=>$text,'parse_mode'=>$parse,'disable_web_page_preview'=>'true'];
    if ($reply_markup) $p['reply_markup']=json_encode($reply_markup);
    return tg('sendMessage',$p);
}
function tg_sendPhoto($chat_id,$file_id,$caption='',$rm=null){ $p=['chat_id'=>$chat_id,'photo'=>$file_id,'caption'=>$caption,'parse_mode'=>'HTML']; if($rm)$p['reply_markup']=json_encode($rm); return tg('sendPhoto',$p); }
function tg_sendVideo($chat_id,$file_id,$caption='',$rm=null){ $p=['chat_id'=>$chat_id,'video'=>$file_id,'caption'=>$caption,'parse_mode'=>'HTML']; if($rm)$p['reply_markup']=json_encode($rm); return tg('sendVideo',$p); }
function tg_sendDocument($chat_id,$file_id,$caption='',$rm=null){ $p=['chat_id'=>$chat_id,'document'=>$file_id,'caption'=>$caption,'parse_mode'=>'HTML']; if($rm)$p['reply_markup']=json_encode($rm); return tg('sendDocument',$p); }
function tg_answerCb($id,$text='',$alert=false){ return tg('answerCallbackQuery',['callback_query_id'=>$id,'text'=>$text,'show_alert'=>$alert?'true':'false']); }
